package AppGioco;

import java.util.*;
import AppGioco.Quadro.*;
import AppGioco.QuadroDedicato.*;

public final class Controlli {
	private Controlli() {
	}

	public static int quantePartite(Quadro q, int n) {
		int result = 0;
		Set<TipoLinkGiocato> ins = q.getLinkGiocato();
		Iterator<TipoLinkGiocato> it = ins.iterator();
		while (it.hasNext()) {
			TipoLinkGiocato t = it.next();
			if (t.getPunti() > n)
				result++;
		}
		return result;
	}

	public static Set<Partita> partiteConPersonaggio(Personaggio p) {
		HashSet<Partita> result = new HashSet<Partita>();
		Iterator<TipoLinkDedicatoA> it = p.getLinkDedicatoA().iterator();
		while (it.hasNext()) {
			TipoLinkDedicatoA t = it.next();
			Iterator<TipoLinkGiocato> itt = t.getQuadroDedicato()
					.getLinkGiocato().iterator();
			while (itt.hasNext())
				result.add(itt.next().getPartita());
		}
		return result;
	}
}
